/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.debug;

import java.io.EOFException;
import java.util.concurrent.CompletableFuture;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.TextArea;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.JavaRuntimeModule;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.AbstractScene;
import pro.gravit.launcher.gui.scenes.debug.ProcessLogOutput;
import pro.gravit.launcher.gui.service.LaunchService;
import pro.gravit.utils.helper.LogHelper;

public class DebugScene
extends AbstractScene {
    private ProcessLogOutput processLogOutput;
    private LaunchService.ClientInstance clientInstance;

    public DebugScene(JavaFXApplication application) {
        super("scenes/debug/debug.fxml", application);
        this.isResetOnShow = true;
    }

    @Override
    protected void doInit() {
        this.processLogOutput = new ProcessLogOutput((TextArea)LookupHelper.lookup((Node)this.layout, "#output"));
        LookupHelper.lookupIfPossible((Node)this.header, "#controls", "#kill").ifPresent(x -> x.setOnAction(e -> {
            if (this.clientInstance != null) {
                this.clientInstance.kill();
            }
        }));
        LookupHelper.lookupIfPossible((Node)this.layout, "#version").ifPresent(v -> v.setText(JavaRuntimeModule.getMiniLauncherInfo()));
        LookupHelper.lookupIfPossible((Node)this.header, "#controls", "#copy").ifPresent(x -> x.setOnAction(e -> this.processLogOutput.copyToClipboard()));
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#back")).setOnAction(e -> {
            if (this.clientInstance != null) {
                this.clientInstance.unregisterListener(this.processLogOutput);
            }
            try {
                this.switchToBackScene();
            }
            catch (Exception ex) {
                this.errorHandle(ex);
            }
        });
    }

    @Override
    public void reset() {
        this.processLogOutput.clear();
    }

    public void onClientInstance(LaunchService.ClientInstance clientInstance) {
        this.clientInstance = clientInstance;
        this.clientInstance.registerListener(this.processLogOutput);
        ((CompletableFuture)this.clientInstance.getOnWriteParamsFuture().thenAccept(ok -> this.processLogOutput.append("[START] Write param successful\n"))).exceptionally(e -> {
            this.errorHandle((Throwable)e);
            return null;
        });
        ((CompletableFuture)this.clientInstance.start().thenAccept(code -> this.processLogOutput.append(String.format("[START] Process exit with code %d", code)))).exceptionally(e -> {
            this.errorHandle((Throwable)e);
            return null;
        });
    }

    public void append(String text) {
        this.processLogOutput.append(text);
    }

    @Override
    public void errorHandle(Throwable e) {
        if (!(e instanceof EOFException) && LogHelper.isDebugEnabled()) {
            this.processLogOutput.append(e.toString());
        }
    }

    @Override
    public String getName() {
        return "debug";
    }
}

